<?php
function set_configuration_to_db( $argv ) {
	/* check number of arguments */
	if( count( $argv ) != 5 ) {
		echo "Usage: " . basename( __FILE__, ".inc" ) . "<DB_HOST> <DB_USERNAME> <DB_PASSWORD> <KEY> <VALUE>\n";
		exit( 1 ) ;
	}

	/* fetch arguments */
	$db_host     = '127.0.0.1';
	$db_username = escapeshellarg( $argv[ 1 ] ) ;
	$db_password = escapeshellarg( $argv[ 2 ] ) ;
	$key         = $argv[ 3 ] ;
	$value       = $argv[ 4 ] ;

	/* execute main function */
    try {
        $connection = pg_connect( "host=$db_host dbname=dtasdb user=$db_username password=$db_password" ) ;
        if( $connection === false ) {
            throw new Exception( "ConnectToDbFail: host='$db_host', user='$db_username'" ) ;
        }

        if( ( pg_query_params(
                $connection,
                "UPDATE tb_global_setting SET value=$1 WHERE key=$2",
                array( $value, $key ) ) ) == false ) {
            
            throw new Exception( pg_last_error() ) ;
        }
        
        pg_close( $connection ) ;
        exit( 0 ) ;
    }
    
    catch( Exception $e ) {
        $msg = "[" . $e -> getFile() . "(" . $e -> getLine() . ")]: " . $e -> getMessage() ;
        
        echo( $msg ) ;
        debug_print( "Exception caught: $msg" ) ;
        
        if( $connection !== false ) {
            pg_close( $connection ) ;
        }
        
        exit( 1 ) ;
    }
}
